/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k.indication.client;

import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCIndicationErrLogger;
import com.ibm.hsc.common.exceptions.HSCException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMNameSpace;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbem.client.CIMClient;

public class HSCCltAuthenticator {
    private CIMObjectPath mObjectPath;
    private String mNameSpace;
    private String mLocalHostName;
    private String mRemoteHostName;
    private long mCreationTime;
    private CIMNameSpace mCIMNameSpace;
    private Vector mInArgs;
    private String mClientInfo;
    public HSCIndicationErrLogger mErrLogger;

    public HSCCltAuthenticator(String string, String string2, String string3, HSCIndicationErrLogger hSCIndicationErrLogger, String string4) {
        block4: {
            this.mObjectPath = null;
            this.mNameSpace = "root/ibmhscV3_2";
            this.mLocalHostName = null;
            this.mRemoteHostName = null;
            this.mCIMNameSpace = null;
            this.mInArgs = null;
            this.mClientInfo = null;
            this.mErrLogger = null;
            try {
                this.mErrLogger = hSCIndicationErrLogger;
                this.mCreationTime = System.currentTimeMillis();
                this.mLocalHostName = string4;
                if (this.mLocalHostName == null) {
                    this.mLocalHostName = InetAddress.getLocalHost().getHostName();
                }
                this.mRemoteHostName = string;
                this.mClientInfo = string3;
                if (string2 != null) {
                    this.mNameSpace = string2;
                }
            }
            catch (Exception exception) {
                if (hSCIndicationErrLogger == null) break block4;
                hSCIndicationErrLogger.logException(exception);
            }
        }
    }

    public void reset() {
        this.mObjectPath = null;
        this.mCIMNameSpace = null;
        this.mInArgs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticate(String string, String string2) throws HSCException {
        CIMClient cIMClient = null;
        try {
            CIMNameSpace cIMNameSpace = this.getCIMNameSpace();
            cIMClient = new CIMClient(cIMNameSpace, string, string2);
            CIMObjectPath cIMObjectPath = this.getCIMObjectPath(cIMClient);
            Vector vector = this.getInArgs();
            CIMValue cIMValue = cIMClient.invokeMethod(cIMObjectPath, "getAuthenticationKey41", vector, new Vector());
            String string3 = (String)cIMValue.getValue();
            return string3;
        }
        catch (Exception exception) {
            if (this.mErrLogger != null) {
                this.mErrLogger.logException(exception);
            }
        }
        finally {
            block14: {
                try {
                    if (cIMClient != null) {
                        cIMClient.close();
                    }
                }
                catch (Exception exception) {
                    if (this.mErrLogger == null) break block14;
                    this.mErrLogger.logException(exception);
                }
            }
        }
        return null;
    }

    private Vector getInArgs() {
        if (this.mInArgs == null) {
            this.mInArgs = new Vector();
            CIMValue cIMValue = new CIMValue((Object)this.mLocalHostName);
            CIMProperty cIMProperty = new CIMProperty("hostName", cIMValue);
            this.mInArgs.addElement(cIMProperty);
            CIMValue cIMValue2 = new CIMValue((Object)new UnsignedInt64("" + this.mCreationTime), new CIMDataType(7));
            CIMProperty cIMProperty2 = new CIMProperty("creationTime", cIMValue2);
            this.mInArgs.addElement(cIMProperty2);
            CIMValue cIMValue3 = new CIMValue((Object)this.mClientInfo);
            CIMProperty cIMProperty3 = new CIMProperty("clientInfo", cIMValue3);
            this.mInArgs.addElement(cIMProperty3);
        }
        return this.mInArgs;
    }

    private CIMNameSpace getCIMNameSpace() {
        if (this.mCIMNameSpace == null) {
            this.mCIMNameSpace = new CIMNameSpace(this.mRemoteHostName, this.mNameSpace);
        }
        return this.mCIMNameSpace;
    }

    private CIMObjectPath getCIMObjectPath(CIMClient cIMClient) throws Exception {
        if (this.mObjectPath == null) {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Console");
            cIMObjectPath.setNameSpace(this.mNameSpace);
            Enumeration enumeration = cIMClient.enumInstances(cIMObjectPath, true);
            this.mObjectPath = (CIMObjectPath)enumeration.nextElement();
        }
        return this.mObjectPath;
    }
}

